<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN900010NL - Signal Notification</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="Sgl/QUMT_MT900010NL.sch"/>

    <!--pattern is-a="attentionLine" id="QUMT_IN900010NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:CategoryEvent/hl7:recordTarget/hl7:Patient/hl7:id"/>
        </pattern-->
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN900010NL-wrapper">
        <param name="element" value="hl7:QUMT_IN900010NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN900010NL-controlAct">
        <param name="element" value="hl7:QUMT_IN900010NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN900010NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN900010NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='AL'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'AL'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN900010NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN900010NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN900010NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern is-a="QUMT_MT900010NL" id="QUMT_IN900010NL-QUMT_MT900010NL">
        <param name="element" value="hl7:ControlActProcess/hl7:subject/hl7:informEvent"/>
    </pattern>
    
    <pattern>
        <title>informevent</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:informEvent">
            <assert role="error" test="hl7:inFulfillmentOf"
                >In deze interactie moet een signaal naar een abonnement verwijzen</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>InformEvent/inFulFillmentOf/subscription</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:informEvent/hl7:inFulfillmentOf/hl7:subscription/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active'"
                >subscription/statusCode moet 'active' zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>informEvent/subjectOf/controlActEvent/code</title>
        <rule context="hl7:ControlActProcess/hl7:subject/hl7:informEvent/hl7:subjectOf/hl7:controlActEvent/hl7:code">
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.12' and @code"
                >controlActEvent/code/@codeSystem moet '2.16.840.1.113883.2.4.3.11.12' zijn en @code moet een geldige waarde bevatten</assert>
        </rule>
    </pattern>
 </schema>
